<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('service_category_id')->references('id')->on('service_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->foreign('specialty_id')->references('id')->on('specialties')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hero_slides', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_features', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_benefits', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_service_category_id_foreign');
		});
		Schema::table('doctors', function(Blueprint $table) {
			$table->dropForeign('doctors_specialty_id_foreign');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->dropForeign('specialty_doctor_specialty_id_foreign');
		});
		Schema::table('specialty_doctor', function(Blueprint $table) {
			$table->dropForeign('specialty_doctor_doctor_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_page_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_service_id_foreign');
		});
		Schema::table('hero_slides', function(Blueprint $table) {
			$table->dropForeign('hero_slides_page_id_foreign');
		});
		Schema::table('service_features', function(Blueprint $table) {
			$table->dropForeign('service_features_service_id_foreign');
		});
		Schema::table('service_benefits', function(Blueprint $table) {
			$table->dropForeign('service_benefits_service_id_foreign');
		});
	}
}