<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamHighlightsTable extends Migration {

	public function up()
	{
		Schema::create('team_highlights', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 255)->nullable();
			$table->string('description')->nullable();
			$table->string('icon', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('sort_order')->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('team_highlights');
	}
}