<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionsTable extends Migration {

	public function up()
	{
		Schema::create('sections', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('page_id')->unsigned();
			$table->string('title', 255);
			$table->string('subtitle', 255)->nullable();
			$table->longText('content')->nullable();
			$table->text('additional_content')->nullable();
			$table->string('image', 255)->nullable();
			$table->text('button')->nullable();
			$table->string('layout_type', 255)->nullable();
			$table->integer('columns')->nullable();
			$table->text('padding')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('sort_order', true)->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sections');
	}
}