<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHeroSlidesTable extends Migration {

	public function up()
	{
		Schema::create('hero_slides', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('page_id')->unsigned();
			$table->string('title', 255)->nullable();
			$table->string('subtitle', 255)->nullable();
			$table->text('description')->nullable();
			$table->string('image', 255)->nullable();
			$table->text('button')->nullable();
			$table->integer('sort_order', true)->unique();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hero_slides');
	}
}