<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpecialtiesTable extends Migration {

	public function up()
	{
		Schema::create('specialties', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 255);
			$table->text('description')->nullable();
			$table->string('image', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->integer('sort_order', true)->unique();
			$table->string('icon', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('specialties');
	}
}