<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('service_category_id')->unsigned();
			$table->string('title', 255);
			$table->text('description')->nullable();
			$table->string('icon')->nullable();
			$table->string('image', 255)->nullable();
			$table->integer('sort_order', true);
			$table->tinyInteger('is_active')->default('1');
			$table->tinyInteger('is_featured')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}