<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('service_categories', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 255);
			$table->string('short_title', 255)->nullable();
			$table->text('description')->nullable();
			$table->string('hero_description', 255)->nullable();
			$table->string('icon', 255)->nullable();
			$table->string('hero_image', 255)->nullable();
			$table->integer('sort_order');
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('service_categories');
	}
}