<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamMembersTable extends Migration {

	public function up()
	{
		Schema::create('team_members', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 255);
			$table->string('role', 255)->nullable();
			$table->string('specialty', 255)->nullable();
			$table->string('email')->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('image', 255)->nullable();
			$table->integer('sort_order')->unique();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('team_members');
	}
}