<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 255);
			$table->string('slug', 255)->nullable();
			$table->string('image', 255)->nullable();
			$table->string('meta_title', 255)->nullable();
			$table->text('meta_description')->nullable();
			$table->string('hero_title', 255)->nullable();
			$table->text('hero_description')->nullable();
			$table->string('hero_image', 255)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}