<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFeaturesTable extends Migration {

	public function up()
	{
		Schema::create('features', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title', 255);
			$table->text('description')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->string('icon', 255)->nullable();
			$table->integer('sort_order')->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('features');
	}
}