<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('label', 255)->nullable();
			$table->string('value', 255)->unique();
			$table->string('icon', 255)->nullable();
			$table->longText('business_hours')->nullable();
			$table->integer('sort_order', true)->unique();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}