<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name', 255)->nullable();
			$table->string('last_name');
			$table->string('email', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->bigInteger('service_id')->unsigned();
			$table->date('preferred_date')->nullable();
			$table->time('preferred_time')->nullable();
			$table->string('status', 255);
			$table->string('notes', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}