<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialLinksTable extends Migration {

	public function up()
	{
		Schema::create('social_links', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('platform', 255);
			$table->string('url', 255);
			$table->string('icon', 255)->nullable();
			$table->integer('sort_order', true)->unique();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('social_links');
	}
}