<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('username');
			$table->string('password');
			$table->string('email');
			$table->string('phone');
			$table->date('last_modified');
			$table->integer('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}