<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSessionTable extends Migration {

	public function up()
	{
		Schema::create('session', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->text('description');
			$table->datetime('start_time');
			$table->datetime('end_time');
			$table->text('url');
			$table->string('status');
			$table->integer('admin_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('session');
	}
}