<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('name');
			$table->string('code', 255);
			$table->double('cost', 255);
			$table->enum('type', array('offer', 'copuon'));
			$table->string('capacity', 255);
			$table->timestamp('end_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}