<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('message');
			$table->integer('user_id')->unsigned();
			$table->integer('tutor_id')->unsigned();
			$table->string('sender')->nullable()->default('user');
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}