<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductLine extends Model 
{

    protected $table = 'product_lines';
    public $timestamps = true;
    protected $fillable = array('name_PT', 'name_EN', 'image', 'category_id', 'brand_id');

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function brand()
    {
        return $this->belongsTo('Brand', 'brand_id');
    }

    public function productModels()
    {
        return $this->hasMany('ProductModel', 'product_line_id');
    }

}