<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class News extends Model 
{

    protected $table = 'news';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'content', 'image_id', 'language_id');

    public function language()
    {
        return $this->belongsTo('Language', 'language_id');
    }

    public function image()
    {
        return $this->hasOne('Image', 'image_id');
    }

}