<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Brand extends Model 
{

    protected $table = 'brands';
    public $timestamps = true;
    protected $fillable = array('name', 'logo', 'description_PT', 'description_EN');

    public function productLines()
    {
        return $this->hasMany('ProductLine', 'brand_id');
    }

    public function productModels()
    {
        return $this->hasManyThrough('ProductModel', 'ProductLine', 'brand_id', 'product_line_id');
    }

}