<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserLog extends Eloquent {

	protected $table = 'user_logs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('description', 'user_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}