<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('active', 'username', 'password', 'email', 'user_role_id', 'fullname', 'social_name', 'address', 'CNPJ', 'IE', 'phone_number');

	public function userRole()
	{
		return $this->belongsTo('UserRole', 'user_role_id');
	}

	public function CityRegion()
	{
		return $this->belongsTo('CityRegion', 'city_and_region_id');
	}

}