<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductDrawing extends Eloquent {

	protected $table = 'product_drawings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'downloads', 'file_2d', 'file_3d', 'product_type_id');

	public function productTypes()
	{
		return $this->belongsTo('ProductType', 'product_type_id');
	}

}