<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Download extends Eloquent {

	protected $table = 'downloads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title_pt', 'title_en', 'thumbnail', 'link', 'exclusive', 'download_type_id');

	public function downloadTypes()
	{
		return $this->belongsTo('DownloadType', 'download_type_id');
	}

}