<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSolutionsTable extends Migration {

	public function up()
	{
		Schema::create('solutions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 256);
			$table->text('content');
			$table->string('banner', 512);
			$table->integer('language_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('solutions');
	}
}