<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('has_skill', function(Blueprint $table) {
			$table->foreign('freelancer_id')->references('id')->on('freelancer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('has_skill', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skill')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('freelancer', function(Blueprint $table) {
			$table->foreign('user_account_id')->references('id')->on('user_account')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hire_manager', function(Blueprint $table) {
			$table->foreign('user_account')->references('id')->on('user_account')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hire_manager', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('client')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->foreign('hire_manager_id')->references('id')->on('hire_manager')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->foreign('main_skill_id')->references('id')->on('skill')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('other_skills', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('job')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('other_skills', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skill')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attachment', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('message')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('job')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->foreign('freelancer_id')->references('id')->on('freelancer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->foreign('current_proposal_status')->references('id')->on('proposal_status_catalog')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->foreign('freelancer_id')->references('id')->on('freelancer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->foreign('hire_manager_id')->references('id')->on('hire_manager')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->foreign('pro_id')->references('id')->on('proposal')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->foreign('proposal_status_catalog')->references('id')->on('proposal_status_catalog')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('free_proposal_and_contract', function(Blueprint $table) {
			$table->foreign('user_account_id')->references('id')->on('user_account')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('pro_id')->references('id')->on('proposal')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('company_proposal_and_contract')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('freelancer_id')->references('id')->on('free_proposal_and_contract')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('payment_type_id')->references('id')->on('payment_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('has_skill', function(Blueprint $table) {
			$table->dropForeign('has_skill_freelancer_id_foreign');
		});
		Schema::table('has_skill', function(Blueprint $table) {
			$table->dropForeign('has_skill_skill_id_foreign');
		});
		Schema::table('freelancer', function(Blueprint $table) {
			$table->dropForeign('freelancer_user_account_id_foreign');
		});
		Schema::table('hire_manager', function(Blueprint $table) {
			$table->dropForeign('hire_manager_user_account_foreign');
		});
		Schema::table('hire_manager', function(Blueprint $table) {
			$table->dropForeign('hire_manager_company_id_foreign');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->dropForeign('job_hire_manager_id_foreign');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->dropForeign('job_main_skill_id_foreign');
		});
		Schema::table('job', function(Blueprint $table) {
			$table->dropForeign('job_payment_type_id_foreign');
		});
		Schema::table('other_skills', function(Blueprint $table) {
			$table->dropForeign('other_skills_job_id_foreign');
		});
		Schema::table('other_skills', function(Blueprint $table) {
			$table->dropForeign('other_skills_skill_id_foreign');
		});
		Schema::table('attachment', function(Blueprint $table) {
			$table->dropForeign('attachment_message_id_foreign');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->dropForeign('proposal_job_id_foreign');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->dropForeign('proposal_freelancer_id_foreign');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->dropForeign('proposal_payment_type_id_foreign');
		});
		Schema::table('proposal', function(Blueprint $table) {
			$table->dropForeign('proposal_current_proposal_status_foreign');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->dropForeign('message_freelancer_id_foreign');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->dropForeign('message_hire_manager_id_foreign');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->dropForeign('message_pro_id_foreign');
		});
		Schema::table('message', function(Blueprint $table) {
			$table->dropForeign('message_proposal_status_catalog_foreign');
		});
		Schema::table('free_proposal_and_contract', function(Blueprint $table) {
			$table->dropForeign('free_proposal_and_contract_user_account_id_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_pro_id_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_company_id_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_freelancer_id_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_payment_type_id_foreign');
		});
	}
}