<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('produtos', function(Blueprint $table) {
			$table->foreign('criado_por')->references('id')->on('usuarios')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fornecedores', function(Blueprint $table) {
			$table->foreign('criado_por')->references('id')->on('usuarios')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orcamentos', function(Blueprint $table) {
			$table->foreign('fk_produto')->references('id')->on('produtos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orcamentos', function(Blueprint $table) {
			$table->foreign('fk_fornecedor')->references('id')->on('fornecedores')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orcamentos', function(Blueprint $table) {
			$table->foreign('fk_usuario')->references('id')->on('usuarios')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->foreign('criado_por')->references('id')->on('usuarios')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('solicitacoes', function(Blueprint $table) {
			$table->foreign('fk_orcamento')->references('id')->on('orcamentos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('solicitacoes', function(Blueprint $table) {
			$table->foreign('fk_pedido')->references('id')->on('pedidos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('produtos', function(Blueprint $table) {
			$table->dropForeign('produtos_criado_por_foreign');
		});
		Schema::table('fornecedores', function(Blueprint $table) {
			$table->dropForeign('fornecedores_criado_por_foreign');
		});
		Schema::table('orcamentos', function(Blueprint $table) {
			$table->dropForeign('orcamentos_fk_produto_foreign');
		});
		Schema::table('orcamentos', function(Blueprint $table) {
			$table->dropForeign('orcamentos_fk_fornecedor_foreign');
		});
		Schema::table('orcamentos', function(Blueprint $table) {
			$table->dropForeign('orcamentos_fk_usuario_foreign');
		});
		Schema::table('pedidos', function(Blueprint $table) {
			$table->dropForeign('pedidos_criado_por_foreign');
		});
		Schema::table('solicitacoes', function(Blueprint $table) {
			$table->dropForeign('solicitacoes_fk_orcamento_foreign');
		});
		Schema::table('solicitacoes', function(Blueprint $table) {
			$table->dropForeign('solicitacoes_fk_pedido_foreign');
		});
	}
}