<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 500);
			$table->longText('description');
			$table->integer('department_id')->unsigned();
			$table->date('start_date');
			$table->date('due_date')->nullable();
			$table->enum('have_deadline', array('0.1'));
			$table->longText('note')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}