<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('address1');
			$table->string('address2');
			$table->string('town');
			$table->string('county');
			$table->string('postcode');
			$table->boolean('marketing');
			$table->string('password');
			$table->tinyInteger('gender');
			$table->float('weight');
			$table->tinyInteger('age')->unsigned();
			$table->tinyInteger('height');
			$table->tinyInteger('activity_level')->unsigned();
			$table->tinyInteger('goal')->unsigned();
			$table->tinyInteger('role')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}