<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNhanvienTable extends Migration {

	public function up()
	{
		Schema::create('nhanvien', function(Blueprint $table) {
			$table->increments('id');
			$table->string('ten');
			$table->string('ho');
			$table->string('cmnd')->nullable();
			$table->date('ngaysinh')->nullable();
			$table->string('sdt')->nullable();
			$table->text('diachi_thuongtru')->nullable();
			$table->text('diachi_tamtru')->nullable();
			$table->string('trinhdo_hocvan')->nullable();
			$table->string('bangcap')->nullable();
			$table->string('mst')->nullable();
			$table->string('tk_nganhang')->nullable();
			$table->string('chinhanh_nganhang')->nullable();
			$table->string('so_bhyt')->nullable();
			$table->date('ngayhethan_bhyt')->nullable();
			$table->string('noidangky_bhyt')->nullable();
			$table->string('so_bhxh')->nullable();
			$table->date('ngaythamgia_bhxh')->nullable();
			$table->text('kynang')->nullable();
			$table->integer('chinhanh_id')->unsigned()->nullable();
			$table->integer('phongban_id')->unsigned()->nullable();
			$table->string('chucdanh')->nullable();
			$table->date('ngaythuviec')->nullable();
			$table->date('lamviechinhthuc')->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('trangthai_nhanvien_id')->unsigned()->nullable();
			$table->text('lydo_nghiviec')->nullable();
			$table->string('nguoiduyet')->nullable();
			$table->string('so_sld')->nullable();
			$table->string('so_ngayphep')->nullable();
			$table->boolean('auto_ngayphep')->nullable()->default(1);
			$table->integer('thuongtru_quanhuyen_id')->unsigned()->nullable();
			$table->integer('thuongtru_tinhthanh_id')->unsigned()->nullable();
			$table->integer('tamtru_quanhuyen_id')->unsigned()->nullable();
			$table->integer('tamtru_tinhthanh_id')->unsigned()->nullable();
			$table->integer('created_by')->unsigned()->nullable();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('nhanvien');
	}
}