<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentReviewsTable extends Migration {

	public function up()
	{
		Schema::create('comment_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('reviewable_type');
			$table->integer('reviewable_id');
			$table->enum('status', array('approved', 'pending', 'rejected'));
			$table->string('comment');
			$table->tinyInteger('rating');
			$table->timestamps();
			$table->softDeletes();
			$table->string('ip')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('comment_reviews');
	}
}