<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttributesTable extends Migration {

	public function up()
	{
		Schema::create('attributes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('category_id');
			$table->string('name', 32);
			$table->string('slug', 128);
			$table->integer('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('attributes');
	}
}