<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title_ar')->nullable();
			$table->string('title_en')->nullable();
			$table->integer('narrator_id')->unsigned();
			$table->string('interview_form')->nullable();
			$table->integer('area_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->integer('document_carrier')->unsigned()->nullable();
			$table->timestamps();
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}