<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentFeatureTable extends Migration {

	public function up()
	{
		Schema::create('document_feature', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('audio', 'video', 'image'));
			$table->string('url')->nullable();
			$table->longText('desc_ar')->nullable();
			$table->longText('desc_en')->nullable();
			$table->string('image')->nullable();
			$table->integer('document_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('document_feature');
	}
}