<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('password', 255);
			$table->datetime('created_at')->nullable();
			$table->string('remember_token', 100)->nullable()->default('Null');
			$table->datetime('updated_at')->nullable();
			$table->string('name', 100);
			$table->string('email', 255)->index();
			$table->string('username', 100);
			$table->integer('account_type')->default('1');
			$table->string('street_address', 100)->nullable()->default('Null');
			$table->integer('zip')->nullable()->default('Null');
			$table->string('city', 50)->nullable()->default('Null');
			$table->string('state', 50)->nullable()->default('Null');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}