<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigIncrements('branch_id');
			$table->increments('user_id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->string('num_of_users');
			$table->string('id_number');
			$table->string('id_name');
			$table->enum('place', array('in', 'out'));
			$table->enum('status', array('refused', 'accepted', 'pending'));
			$table->longText('cancel_reason')->nullable();
			$table->string('transaction_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}