<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGeneralReservationsTable extends Migration {

	public function up()
	{
		Schema::create('general_reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('user_id');
			$table->string('face_book');
			$table->string('instagram');
			$table->string('twitter');
			$table->longText('description');
			$table->longText('additional');
			$table->longText('conditions');
			$table->timestamps();
			$table->enum('booking_with_money', array('yes', 'no'));
		});
	}

	public function down()
	{
		Schema::drop('general_reservations');
	}
}