<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 191);
			$table->string('email', 191)->unique();
			$table->integer('phone');
			$table->integer('country')->unsigned();
			$table->integer('city')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}