<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('price');
			$table->date('created');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->enum('contact_option', array('private', 'mobile', 'email'));
			$table->date('year')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}