<?php

namespace product;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	public function buyer()
	{
		return $this->belongsTo('Buyer');
	}

	public function brand()
	{
		return $this->belongsTo('Brand');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function label()
	{
		return $this->belongsTo('Label');
	}

	public function vendorProducts()
	{
		return $this->hasMany('Vendor_product');
	}

	public function customFields()
	{
		return $this->hasMany('Custom_fields');
	}

	public function productVariations()
	{
		return $this->hasMany('Product_variation');
	}

	public function items()
	{
		return $this->hasMany('Bundle_kit_items');
	}

}