<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuditLogsTable extends Migration {

	public function up()
	{
		Schema::create('audit_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->morphs('related_model');
			$table->text('action');
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('audit_logs');
	}
}