<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSeriesTable extends Migration {

	public function up()
	{
		Schema::create('series', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('slug')->unique();
			$table->integer('quality_id')->unsigned()->nullable()->index();
			$table->string('description')->nullable();
			$table->integer('episodes_duration');
			$table->string('the_beginning', 4);
			$table->string('the_end', 4)->nullable();
			$table->boolean('finished')->default(false);
			$table->string('imdb_id')->nullable();
			$table->string('allocine_id')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('series');
	}
}