<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEpisodesTable extends Migration {

	public function up()
	{
		Schema::create('episodes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('season_number');
			$table->integer('episode_number');
			$table->integer('serie_id')->unsigned()->nullable()->index();
			$table->integer('version_id')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->string('slug');
		});
	}

	public function down()
	{
		Schema::drop('episodes');
	}
}