<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('parent_id')->unsigned()->index();
			$table->tinyInteger('status');
			$table->text('tags');
			$table->integer('sort');
			$table->bigInteger('resturant_id')->unsigned()->index();
			$table->tinyInteger('show_in_navbar');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}