<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('emp_status_id')->references('id')->on('emp_status')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('designation_id')->references('id')->on('designations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_policies', function(Blueprint $table) {
			$table->foreign('leave_type_id')->references('id')->on('leave_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_policy_details', function(Blueprint $table) {
			$table->foreign('leave_policy_id')->references('id')->on('leave_policies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_policy_user', function(Blueprint $table) {
			$table->foreign('leave_policy_id')->references('id')->on('leave_policies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_policy_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_type_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('leave_type_user', function(Blueprint $table) {
			$table->foreign('leave_type_id')->references('id')->on('leave_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_emp_status_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_designation_id_foreign');
		});
		Schema::table('attendance', function(Blueprint $table) {
			$table->dropForeign('attendance_user_id_foreign');
		});
		Schema::table('leave_policies', function(Blueprint $table) {
			$table->dropForeign('leave_policies_leave_type_id_foreign');
		});
		Schema::table('leave_policy_details', function(Blueprint $table) {
			$table->dropForeign('leave_policy_details_leave_policy_id_foreign');
		});
		Schema::table('leave_policy_user', function(Blueprint $table) {
			$table->dropForeign('leave_policy_user_leave_policy_id_foreign');
		});
		Schema::table('leave_policy_user', function(Blueprint $table) {
			$table->dropForeign('leave_policy_user_user_id_foreign');
		});
		Schema::table('leave_type_user', function(Blueprint $table) {
			$table->dropForeign('leave_type_user_user_id_foreign');
		});
		Schema::table('leave_type_user', function(Blueprint $table) {
			$table->dropForeign('leave_type_user_leave_type_id_foreign');
		});
	}
}