<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->increments('id');
			$table->text('name')->nullable();
			$table->text('path')->nullable();
			$table->bigInteger('question_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('order_Id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}