<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_inputs', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fields', function(Blueprint $table) {
			$table->foreign('user_input_id')->references('id')->on('user_inputs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('item_section_id')->references('id')->on('item_sections')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('item_sections', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('seo', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('user_inputs', function(Blueprint $table) {
			$table->dropForeign('user_inputs_product_id_foreign');
		});
		Schema::table('fields', function(Blueprint $table) {
			$table->dropForeign('fields_user_input_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_product_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_item_section_id_foreign');
		});
		Schema::table('item_sections', function(Blueprint $table) {
			$table->dropForeign('item_sections_product_id_foreign');
		});
		Schema::table('seo', function(Blueprint $table) {
			$table->dropForeign('seo_product_id_foreign');
		});
	}
}