<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldsTable extends Migration {

	public function up()
	{
		Schema::create('fields', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_input_id')->unsigned();
			$table->enum('tag', array('input', 'dropdown'));
			$table->string('type')->default('text');
			$table->string('name')->nullable();
			$table->string('placehoder')->nullable();
			$table->json('datas')->nullable();
			$table->boolean('required')->default(true);
			$table->integer('ordered')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fields');
	}
}