<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->integer('family_id')->unsigned();
			$table->decimal('total_price', 10,2)->nullable();
			$table->decimal('tax', 10,2)->nullable();
			$table->decimal('net', 10,2)->nullable();
			$table->enum('status', array('1', '2', '3', '4'));
			$table->enum('delivery_type', array('1', '2', '3'));
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}