<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfersTable extends Migration {

	public function up()
	{
		Schema::create('transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code')->nullable();
			$table->date('date')->nullable();
			$table->integer('inventory_from');
			$table->integer('inventory_to');
			$table->float('total')->default('0');
			$table->integer('created_by')->nullable();
			$table->integer('confirmed_by')->nullable();
			$table->timestamp('confirmed_at')->nullable();
			$table->string('status', 10)->default('OPEN');
			$table->boolean('is_reserved')->default(0);
			$table->text('noted')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transfers');
	}
}